# “奇美拉” (Chimera)：集大成者——终极安全渗透智能体详细设计架构

## 1. 设计哲学：融合与升华

“奇美拉” (Chimera) 架构的设计哲学，是对本次腾讯智能渗透挑战赛所有优胜队伍智慧的集大成。它并非单一模式的简单重复，而是将“分而治之”的严谨与“大道至简”的灵动、“团队协作”的广度与“专家制衡”的深度、“配置驱动”的灵活与“协议解耦”的健壮进行有机融合。其核心思想是：

> **在一个由标准协议解耦的、配置驱动的健壮框架之上，构建一个由“战略规划-战术执行-质量保证”构成的、具备自省与协同能力的多Agent团队。**

## 2. 总体架构：三层解耦的“洋葱模型”

Chimera采用三层完全解耦的“洋葱模型”架构，从内到外分别是：**工具与环境层**、**能力与协议层**、**决策与策略层**。

```mermaid
graph TD
    subgraph "决策与策略层 (The Brains)"
        direction LR
        A[Orchestrator Agent (战略规划师)]
        subgraph "Agent团队 (通过YAML配置动态生成)"
            B[Recon Agent (侦察专家)]
            C[Analysis Agent (分析专家)]
            D[Exploit Agent (利用专家)]
            E[... (可扩展)]
        end
        F[Advisor Agent (顾问/质保)]
        A -- 调度 --> B & C & D & E
        B & C & D & E -- 定期/失败时求助 --> F
        F -- 提供建议/否决 --> B & C & D & E
        A & B & C & D & E & F -- "发送MCP请求" --> G{MCP客户端};
    end

    subgraph "能力与协议层 (The Nervous System)"
        G -- "MCP (JSON over HTTP/2)" --> H{MCP服务器 (网关)};
    end

    subgraph "工具与环境层 (The Body)"
        direction LR
        H -- "解析请求, 调用工具" --> I[通用命令执行器 (Docker沙箱)];
        H -- "解析请求, 调用工具" --> J[代码执行器 (Python/Node.js沙箱)];
        H -- "解析请求, 调用工具" --> K[浏览器自动化 (Playwright/Selenium)];
        H -- "解析请求, 调用工具" --> L[RAG知识库 (向量数据库)];
        H -- "解析请求, 调用工具" --> M[状态/记忆存储 (Redis)];
    end
```

### 2.1. 决策与策略层 (The Brains)

这是Agent的“大脑”，完全负责思考和决策，不执行任何实际操作。所有Agent均通过**YAML配置文件**进行定义和编排，由一个主程序动态加载。

- **战略规划师 (Orchestrator Agent)**: 顶层管理者，类似`xjtuHunter`的主Agent。它接收最高层级的任务意图（如“拿下`target.com`”），负责将任务分解为阶段性目标（如“信息收集”、“漏洞分析”、“权限提升”），并动态地将这些子任务分配给合适的专家Agent。它持续监控全局状态，并根据进展调整整体战略。

- **专家Agent团队 (Specialist Agents)**: 一组由`CrewAI`或`LangGraph`管理的、角色明确的Agent，类似`newmapta`和`sickhack`的设计。
    - **侦察专家 (Recon Agent)**: 负责资产发现、端口扫描、子域名枚举、指纹识别等。
    - **分析专家 (Analysis Agent)**: 负责Web爬取、目录扫描、API分析、源码审计、前端JS分析等。
    - **利用专家 (Exploit Agent)**: 负责根据分析结果，选择并执行具体的漏洞利用，如SQL注入、RCE、XSS等。
    - **...可扩展**: 可以通过YAML配置轻松添加新的专家，如`PrivEsc Agent`（提权专家）、`Forensics Agent`（取证专家）等。

- **顾问/质保Agent (Advisor Agent)**: 灵感源于`yhy`的“顾问”。这是一个不执行任务，但拥有“一票否决权”的特殊Agent。它的职责是：
    - **事前审查**: 在任何高风险或高成本的命令（如`rm -rf`, `sqlmap --level=5`）执行前，必须经过它的审查和批准。
    - **事中干预**: 当任何专家Agent连续多次失败或陷入循环时，Orchestrator会强制要求其向Advisor咨询，获取“第二意见”。
    - **事后复盘**: 在任务结束后，对关键的成功或失败路径进行总结，形成新的知识存入RAG知识库。

### 2.2. 能力与协议层 (The Nervous System)

这是连接“大脑”和“身体”的“神经系统”，其核心是`ai小分队`提出的**模型上下文协议 (MCP)**。

- **MCP客户端**: 内嵌于决策层的每个Agent中，负责将Agent的工具调用意图（如`run_command(
