# 基米牌南北绿豆好吃吗 队伍 - BUUCTF_Agent 技术分析

## 基本信息

基米牌南北绿豆好吃吗队伍开发了BUUCTF_Agent，这是一个面向CTF竞赛的AI Agent自动化解题系统。项目起源于个人练手，但愿景是成为各路CTF大手子的好伙伴。

| 属性 | 信息 |
|------|------|
| 队伍名称 | 基米牌南北绿豆好吃吗 |
| 项目名称 | BUUCTF_Agent |
| GitHub | https://github.com/MuWinds/BUUCTF_Agent |
| 开发者 | @MuWinds |

## 核心功能

系统支持全自动解题，包括题目分析、靶机探索、代码执行、flag分析全流程。同时支持命令行交互式解题模式。项目内置支持Python工具和SSH到装好环境的Linux机器进行解题，提供可扩展的CTF工具框架和可自定义的Prompt和模型文件。系统还提供实时可视化的Web控制台，支持配置编辑与任务终止。

## 架构设计

### 多模型配置

系统为不同任务配置不同的LLM模型，实现任务分工：

| 任务类型 | 推荐模型 | 功能 |
|----------|----------|------|
| analyzer | DeepSeek-R1 | 题目分析和推理 |
| solve_agent | DeepSeek-V3 | 解题执行 |
| pre_processor | Qwen3-8B | 预处理 |

### 上下文管理

系统提供智能的上下文管理机制。max_history_steps参数设置最大历史步骤数（默认15），compression_threshold参数设置压缩阈值（默认7），当历史记录超过阈值时自动压缩。

### 工具系统

系统采用可扩展的工具框架设计。BaseTool抽象基类定义了工具接口，每个工具必须实现execute方法（执行工具操作，返回正常输出和错误输出的元组）和function_config属性（返回工具的函数调用配置，供LLM决定何时调用）。

内置工具包括Python执行工具（在本地或容器中执行Python代码）和SSH Shell工具（在远程Linux服务器上执行Shell命令，服务器内提供curl、sqlmap、nmap、openssl等常用工具）。

### MCP支持

系统支持MCP（Model Context Protocol）服务器集成，可以通过配置添加外部MCP服务器扩展功能。配置示例支持stdio类型的MCP服务器。

## Web控制台

项目提供FastAPI + 前端静态页面的Web控制台，功能包括在线查看与编辑当前生效的config.json、上传/删除附件（保存到项目根目录的attachments目录）、启动/终止Agent会话并实时查看日志事件流、对模型推理出的flag进行人工确认后再提交。

## 部署方式

### 本地运行

系统支持在Linux/WSL环境下本地运行，通过虚拟环境安装依赖，配置config.json后即可启动命令行模式或Web UI。

### Docker部署

推荐使用Docker进行隔离运行，项目提供Dockerfile，支持挂载配置文件和附件目录，默认SSH用户为root，密码为ctfagent。

## 技术亮点

BUUCTF_Agent的技术亮点主要体现在以下几个方面。首先是多模型分工，为不同任务（分析、解题、预处理）配置不同模型，发挥各模型优势。其次是可扩展工具框架，通过抽象基类定义工具接口，便于添加新工具。第三是上下文压缩，自动压缩历史记录，控制上下文长度。第四是MCP集成，支持外部MCP服务器扩展功能。第五是Web控制台，提供实时可视化界面，支持配置管理和任务控制。

## 安全提示

该项目能在被配置的工具上执行任意Shell/代码，请勿在含有重要数据或生产环境的机器上无充分隔离地运行Agent。对外提供Web UI或开放端口时请做好访问控制与凭证管理。

## 未来计划

项目计划支持更多工具（如二进制分析等），不局限于Web题和Web相关的密码学。计划添加RAG知识库功能，实现不同OJ平台的自动化，提供手动输入题面之外更便捷的选择。
