# BUUCTF_Agent DeepWiki深度分析

## 项目概述

BUUCTF_Agent是一个AI驱动的自主Agent系统，专门用于解决CTF（Capture The Flag）网络安全挑战。系统编排多个大型语言模型（LLM），通过可扩展的工具框架执行命令，并维护上下文记忆以迭代方式解决复杂的安全问题。

## 核心特性

| 特性 | 描述 |
|------|------|
| **多Agent LLM架构** | 三个专门的Agent（预处理器、分析器、解题Agent）协作理解、规划和执行解决方案 |
| **可扩展工具框架** | 动态工具加载系统，支持Python执行、SSH远程命令和MCP协议集成 |
| **智能记忆管理** | 维护执行历史，自动压缩以管理上下文窗口 |
| **交互和自主模式** | 支持完全自主解题和逐步交互指导 |

## 系统架构

### 多Agent LLM架构

BUUCTF_Agent采用三层Agent架构，每个Agent有专门的角色并使用针对其任务优化的不同LLM：

| Agent | 代码位置 | LLM配置 | 职责 |
|-------|----------|---------|------|
| **预处理器** | agent/workflow.py pre_processor() | Qwen3-8B | 文本摘要和优化以减少token使用 |
| **分析器** | agent/workflow.py analyzer() | DeepSeek-R1 | 链式思维推理用于问题分类和规划 |
| **解题Agent** | agent/solve_agent.py SolveAgent | DeepSeek-V3 | 带工具调用的迭代执行循环 |

### 工作流程

```
问题输入 → 预处理器(文本优化) → 分析器(问题分类/规划) → 解题Agent(迭代执行) → Flag输出
```

## 工具框架

### 插件架构

工具系统实现了基于`BaseTool`抽象类的插件架构（位于`ctf_tool/base_tool.py`）。自定义工具必须实现两个方法：

1. **execute(*args, **kwargs) -> Tuple[str, str]**: 执行实际操作并返回(stdout, stderr)
2. **function_config属性**: 返回OpenAI兼容的函数调用模式

### 内置工具

| 工具 | 位置 | 功能 |
|------|------|------|
| **SSHShell** | ctf_tool/ssh_shell.py | 通过SSH远程命令执行 |
| **PythonTool** | ctf_tool/python.py | 本地或远程Python代码执行 |
| **MCPAdapter** | ctf_tool/mcp_adapter.py | 与MCP兼容的外部工具集成 |

### 动态工具加载

`load_tools()`函数（位于`ctf_tool/load_tool.py`）动态发现`ctf_tool/`目录中所有继承自`BaseTool`的类，实例化它们，并生成可用工具的注册表及其函数配置供LLM使用。

## 记忆和上下文管理

`Memory`类（位于`agent/memory.py`）实现三层存储策略：

| 层级 | 存储内容 | 说明 |
|------|----------|------|
| **最近详细历史** | self.history | 最后N步的完整详细信息 |
| **关键事实** | self.key_facts | 提取的重要发现 |
| **压缩摘要** | self.compressed_history | 历史上下文压缩为JSON摘要 |

### 自动压缩机制

当步骤数超过`compression_threshold`（默认：7）时，`compress_history()`方法调用LLM生成包含关键发现、失败尝试、当前状态和下一步的结构化摘要。系统维护最多`max_history_steps`（默认：15）以防止无限增长。

## 配置系统

系统通过`config.json`配置，由`Config`类（位于`config.py`）加载：

```json
{
  "llm": {
    "analyzer": { "model": "...", "api_key": "...", "api_base": "..." },
    "solve_agent": { "model": "...", "api_key": "...", "api_base": "..." },
    "pre_processor": { "model": "...", "api_key": "...", "api_base": "..." }
  },
  "max_history_steps": 15,
  "compression_threshold": 7,
  "tool_config": {
    "ssh_shell": { "host": "...", "port": 22, "username": "...", "password": "..." }
  },
  "mcp_server": { ... }
}
```

## 操作模式

| 模式 | 描述 | 使用场景 |
|------|------|----------|
| **自主模式** | Agent连续执行步骤无需用户确认 | 完全自动化问题解决，无需干预 |
| **交互模式** | Agent在每次工具执行前请求用户批准 | 学习、调试或需要监督的高风险操作 |

在两种模式下，当检测到潜在的flag模式（如`flag{...}`或`ctf{...}`）时，Agent始终提示用户确认后再报告flag作为最终解决方案。

## 安全考虑

**关键警告**: BUUCTF_Agent执行LLM生成的shell命令和代码。系统设计为与Docker容器或隔离的虚拟机环境一起使用。永远不要使用包含重要数据的系统的SSH凭证运行Agent。

提供的Dockerfile创建了一个预配置安全工具（nmap, sqlmap, hashcat, john the ripper等）的隔离环境，专门用于CTF挑战。

## 技术亮点

1. **三层Agent架构** - 预处理器、分析器、解题Agent分工明确
2. **插件化工具系统** - 基于BaseTool的可扩展设计
3. **智能记忆压缩** - 自动压缩历史防止上下文溢出
4. **MCP协议支持** - 集成Model Context Protocol
5. **Docker隔离** - 安全的执行环境

## 项目愿景

项目旨在成为CTF竞赛者和安全研究人员的可靠伙伴。虽然最初专注于Web挑战和Web相关密码学，但可扩展架构支持未来扩展到二进制分析、逆向工程和其他CTF类别。计划的增强功能包括Web UI、RAG知识库和流行CTF平台的自动集成。
