# C1JC 队伍 - AgentNote 技术分析

## 基本信息

C1JC队伍来自中国传媒大学，开发了AgentNote系统。这是一个基于OODA（Observe-Orient-Decide-Act）循环驱动的自主Agent框架，专注于在计算笔记本环境中进行迭代式问题解决。

| 属性 | 信息 |
|------|------|
| 队伍名称 | C1JC |
| 所属单位 | 中国传媒大学 |
| 项目名称 | AgentNote |
| GitHub | https://github.com/C1JC/AgentNote |
| 核心理念 | Talk is cheap, show me the notebook |

## 核心设计理念

AgentNote致力于创建一个框架，让AI Agent能够自主探索、实验和学习。与此同时，所有思考和执行过程都会自动记录到可重现的笔记本中，有效增强Agent决策和执行的可读性、可信度和可复用性。

通过编排专门的AI Agent进行认知决策循环，AgentNote实现了自主探索、分析和解决方案生成，同时自动将整个过程记录在可执行的笔记本中。

## OODA循环架构

AgentNote的核心是OODA循环架构，这是一种源自军事决策理论的认知框架，包含四个阶段：

### Circle（循环）

Circle是最高级别的执行单元，代表一次完整的OODA迭代。每个Circle包含四个顺序阶段，旨在通过迭代改进向任务目标取得进展。其关键特征包括包含4个阶段（Observe → Orient → Decide → Act）、每次迭代后评估整体进展、支持多个Circle用于复杂问题分解。

### Phase（阶段）

Phase是中间执行单元，代表Circle内的四个OODA阶段之一。每个阶段编排专门的Agent来完成特定的认知任务。

| 阶段 | 功能 |
|------|------|
| Observe（观察） | 环境扫描和数据收集 |
| Orient（定向） | 信息综合和模式识别 |
| Decide（决策） | 策略制定和决策 |
| Act（行动） | 计划执行和解决方案实施 |

### Task（任务）

Task是每个阶段内的基本执行单元，代表特定的Agent操作。每个阶段包含三个顺序任务以实现全面执行。

| 任务类型 | 功能 |
|----------|------|
| Commander Task | 为阶段生成具体任务描述 |
| Agent Task | 使用生成的描述执行专门的认知工作 |
| Reflection Task | 评估任务完成情况并提供反馈 |

### Context（上下文）

Context是共享内存系统，基于持久化笔记本单元格在所有执行级别之间维护状态，实现跨迭代的连续性和学习。

| 上下文组件 | 功能 |
|------------|------|
| Mission Context | 整体目标和约束 |
| Circle Context | 当前迭代的进展和洞察 |
| Phase Context | 阶段特定信息和结果 |
| Task Context | 执行详情和错误历史 |
| Error Context | 代码执行错误消息 |

## 多Agent架构

系统采用OODA驱动的多Agent架构，包含多种专门化Agent：

Observe Agents负责收集环境数据和自身能力信息。Orient Agents负责分析和综合收集的信息。Decision Agents负责制定策略和做出明智决策。Action Agents负责执行由决策指导的操作。Commander Agents模拟人类专家，协调整个OODA循环过程。

## 自主笔记本生成

AgentNote的一大特色是自主笔记本生成能力。系统支持迭代式问题解决，通过多个OODA循环进行复杂问题分解。自动文档功能将完整的思考过程捕获在Markdown和代码单元格中。生成的笔记本是可执行工件，可以立即执行和重现。上下文保存功能在迭代循环中维护状态和上下文。

## 高级能力

系统具备多项高级能力。智能错误恢复提供具有上下文重试策略的自我纠正机制。在线反思功能持续评估进展和目标达成情况。可扩展架构采用模块化设计，支持可扩展的Agent能力。

## 技术亮点

AgentNote的技术亮点主要体现在以下几个方面。首先是OODA循环框架，将军事决策理论应用于AI Agent，提供结构化的认知决策流程。其次是笔记本即文档，所有执行过程自动记录为可执行笔记本，增强可解释性和可重现性。第三是多层次执行单元，Circle、Phase、Task三层架构支持复杂问题的分解和迭代解决。第四是上下文持久化，通过笔记本单元格实现跨迭代的状态维护和知识积累。第五是自我反思机制，每个任务后进行反思评估，支持自我纠正和改进。

## 安全考虑

AgentNote在本地环境中执行AI生成的代码，因此需要注意安全问题。生成的代码以用户权限运行，建议在生产环境中执行前始终审查生成的代码，推荐使用虚拟环境或容器进行环境隔离。
