# HRP 队伍 - H-Pentest 2.0 技术分析

## 基本信息

HRP队伍开发了H-Pentest 2.0，这是一个基于大语言模型(LLM)驱动的全自动化渗透测试平台。该平台采用多Agent协作架构，集成了52+攻击知识库、Docker沙箱环境和实时可视化界面，在腾讯云黑客松智能渗透挑战赛中获得TOP20。

| 属性 | 信息 |
|------|------|
| 队伍名称 | HRP |
| 排名 | TOP20 |
| 项目名称 | H-Pentest 2.0 |
| GitHub | https://github.com/hexian2001/H-pentest |
| 核心特点 | 全异步架构、三层智能决策、50+攻击知识库、Docker容器化、实时可视化 |

## 多Agent协作架构

H-Pentest采用三层智能决策的多Agent协作系统，各层Agent各司其职：

### Meta Supervisor（元监督层）

元监督层每3轮生成元层洞察，负责自主决策是否停止测试。该层具备模式感知能力，能够区分CTF模式和RealWorld模式，并分析Agent表现给出建议。

### Strategic Supervisor（战略规划层）

战略规划层负责生成初始测试计划，每轮动态调整测试策略，并基于执行结果优化方案。

### Worker Agent（执行层）

执行层使用GLM-4.6模型实现快速响应，采用ReAct执行框架（推理→行动→观察→反思），集成工具调用和结果分析能力。

### Payload Master（载荷大师）

载荷大师每3轮提供专业测试指导，能够识别漏洞类型并生成载荷，提供攻击思路进化说明。

### Report Supervisor（报告生成层）

报告生成层负责分析完整对话历史，自动提取漏洞信息，重建攻击路径并生成报告。

## 攻击知识库

系统基于105个真实案例提取了52+攻击知识文档，覆盖多种漏洞类型：

| 漏洞类型 | 文档数量 | 主要内容 |
|----------|----------|----------|
| IDOR攻击 | 5个 | URL参数枚举、POST修改、Cookie篡改、JWT令牌攻击、间接对象引用 |
| 注入攻击 | 15个 | SQL注入、布尔盲注、时间延迟注入、命令注入、过滤绕过、SSTI模板注入、沙箱逃逸、NoSQL注入、OGNL注入 |
| XSS攻击 | 5个 | 反射型、存储型、DOM型XSS、JSFuck编码绕过、过滤绕过技术 |
| 文件相关 | 8个 | 文件上传漏洞、LFI/RFI、路径遍历、日志注入RCE |
| 权限相关 | 10个 | JWT令牌攻击、OAuth绕过、权限提升、业务逻辑漏洞 |
| 其他漏洞 | 20+个 | SSRF、XXE、反序列化、竞态条件、密码学攻击、API安全、GraphQL注入 |

## 集成工具

| 工具名称 | 类型 | 功能描述 |
|----------|------|----------|
| execute_python | Python沙箱 | Docker容器隔离执行，512MB内存，预装渗透库 |
| nuclei_scan | 漏洞扫描 | 11,000+CVE模板，支持严重度过滤 |
| dirscan | 目录扫描 | 快速发现隐藏路径和目录 |
| query_knowledge | 知识库查询 | RAG检索52+攻击知识文档 |
| kali_execute | Kali工具 | 执行预装的渗透测试工具 |

## 双模式支持

### CTF模式

CTF模式采用激进攻击策略，快速寻找FLAG，支持自动提交功能和自定义目标。

### RealWorld模式

RealWorld模式采用稳健测试策略，进行全面漏洞评估，生成专业报告。

## 实时可视化界面

系统提供完整的Web界面，包括Dashboard（任务统计、实时监控面板）、Monitor（多Agent消息流实时展示）、Report（自动生成的漏洞报告）、TaskList（智能任务列表管理）和Settings（动态配置管理）。

## 智能上下文管理

系统集成LangChain，支持120K Token上下文，提供智能压缩功能自动压缩历史对话，支持对话恢复和历史对话完整恢复，通过Token优化大幅降低API成本。

## 技术栈

后端采用FastAPI + Python 3.10+，全异步架构。前端使用Vue 3 + TypeScript + Element Plus。数据库使用SQLite + aiosqlite。容器化方案采用Docker + Docker Compose。AI模型使用OpenAI API兼容模型（智谱AI GLM-4.6）。RAG系统支持Embedding和Rerank模型。

## 技术亮点

H-Pentest的技术亮点主要体现在以下几个方面。首先是三层决策架构，Meta、Strategic、Worker三层Agent协同工作，实现智能决策。其次是丰富的知识库，52+攻击知识文档基于真实案例提取，覆盖主流漏洞类型。第三是双模式支持，CTF激进模式和RealWorld稳健模式适应不同场景。第四是实时可视化，完整的Web界面支持任务监控、消息流展示和报告生成。第五是Docker隔离，Python沙箱和Kali工具容器确保执行安全。第六是RAG知识检索，支持Embedding和Rerank的知识库检索系统。
