# 小白战队 - CyberStrikeAI 技术分析

## 基本信息

小白战队开发了CyberStrikeAI，这是一个基于Go语言构建的AI原生安全测试平台。该平台集成了100多个安全工具、智能编排引擎和全面的生命周期管理能力，通过原生MCP协议和AI代理实现从对话命令到漏洞发现、攻击链分析、知识检索和结果可视化的端到端自动化。

| 属性 | 信息 |
|------|------|
| 队伍名称 | 小白战队 |
| 项目名称 | CyberStrikeAI |
| GitHub | https://github.com/Ed1s0nZ/CyberStrikeAI |
| 开发语言 | Go |

## 设计理念

该项目的核心理念体现在其设计哲学中：在安全领域，真正稀缺的不是工具，而是判断力；判断力源于经验，而经验往往与个人绑定，难以传承和复用。CyberStrikeAI不试图自动化攻击，而是专注于一个更难的问题：在复杂、动态和不确定的环境中，下一步应该做什么，以及为什么。它不追求更激进的自动化，而是寻求将安全专家的思维方式——他们的决策路径和从失败中汲取的教训——转化为一种受约束、可审计、可进化的系统能力。

## 核心特性

CyberStrikeAI具备多项突出特性。在AI决策引擎方面，支持OpenAI兼容模型（GPT、Claude、DeepSeek等），能够根据上下文智能选择和编排工具。在MCP协议实现方面，原生支持HTTP和stdio两种传输方式，并支持外部MCP联邦。

平台内置100多个预构建工具配方，采用YAML格式的扩展系统，便于自定义和扩展。对于大型结果，系统提供分页、压缩和可搜索存档功能。攻击链图功能支持风险评分和逐步重放，帮助安全人员理解攻击路径。系统还提供密码保护的Web UI、审计日志和SQLite持久化存储。

知识库功能支持向量搜索和混合检索，为AI提供安全专业知识支持。对话分组功能支持固定、重命名和批量管理。漏洞管理功能提供CRUD操作、严重性跟踪、状态工作流和统计信息。

## 工具概览

CyberStrikeAI集成了覆盖整个攻击链的100多个精选工具：

| 类别 | 工具 |
|------|------|
| 网络扫描器 | nmap、masscan、rustscan、arp-scan、nbtscan |
| Web和应用扫描器 | sqlmap、nikto、dirb、gobuster、feroxbuster、ffuf、httpx |
| 漏洞扫描器 | nuclei、wpscan、wafw00f、dalfox、xsser |
| 子域名枚举 | subfinder、amass、findomain、dnsenum、fierce |
| 网络空间搜索引擎 | fofa_search、zoomeye_search |
| API安全 | graphql-scanner、arjun、api-fuzzer、api-schema-analyzer |
| 容器安全 | trivy、clair、docker-bench-security、kube-bench、kube-hunter |
| 云安全 | prowler、scout-suite、cloudmapper、pacu、terrascan、checkov |
| 二进制分析 | gdb、radare2、ghidra、objdump、strings、binwalk |
| 漏洞利用 | metasploit、msfvenom、pwntools、ropper、ropgadget |
| 密码破解 | hashcat、john、hashpump |
| 取证 | volatility、volatility3、foremost、steghide、exiftool |
| 后渗透 | linpeas、winpeas、mimikatz、bloodhound、impacket、responder |
| CTF工具 | stegsolve、zsteg、hash-identifier、fcrackzip、pdfcrack、cyberchef |
| 系统辅助 | exec、create-file、delete-file、list-files、modify-file |

## 架构设计

### 工具编排与扩展

工具配置采用YAML格式存储在tools/*.yaml中，描述命令、参数、提示和元数据。系统支持目录热重载，将security.tools_dir指向文件夹即可自动加载。对于超过200KB的大型结果，系统会存储为可通过query_execution_result工具检索的工件，支持分页、过滤和正则搜索。多兆字节的日志可以在持久化前进行摘要或无损压缩。

### 攻击链智能

AI解析每次对话以组装目标、工具、漏洞和关系。Web UI将攻击链渲染为交互式图形，支持严重性评分和步骤重放。攻击链或原始发现可以导出到外部报告管道。

### MCP无处不在

系统支持三种MCP模式：Web模式（HTTP MCP服务器自动被UI消费）、MCP stdio模式（通过go run cmd/mcp-stdio/main.go暴露代理给Cursor/CLI）以及外部MCP联邦（从UI注册第三方MCP服务器，按参与度切换，实时监控健康状况和调用量）。

### 知识库

知识库功能支持向量搜索，AI代理可以在对话期间使用search_knowledge_base工具自动搜索相关安全知识。混合检索结合向量相似性搜索和关键词匹配以提高准确性。自动索引功能扫描knowledge_base/目录中的Markdown文件并自动使用嵌入进行索引。Web管理界面支持创建、更新、删除知识项，并按类别组织。检索日志跟踪所有知识检索操作以供审计和调试。

## 技术亮点

CyberStrikeAI的技术亮点主要体现在以下几个方面。首先是工具生态丰富，集成100多个安全工具，覆盖完整攻击链。其次是YAML配置驱动，工具定义采用声明式配置，易于扩展和维护。第三是攻击链可视化，自动构建攻击链图，支持风险评分和步骤重放。第四是知识库集成，结合向量搜索和混合检索，为AI提供领域知识支持。第五是MCP协议支持，原生支持多种MCP传输方式，便于与其他工具集成。最后是安全审计，完整的审计日志和权限控制，确保操作可追溯。

## 技术栈

后端采用Go语言开发，前端提供Web控制台，数据存储使用SQLite，向量搜索用于知识库检索，支持OpenAI兼容API（GPT、Claude、DeepSeek等）。
