# 瀚海星云 队伍 - sub-agent-autopt 技术分析

## 基本信息

瀚海星云队伍来自中国科学技术大学网络信息中心，开发了sub-agent-autopt，一个基于多Agent架构的自动化安全测试系统。该项目在腾讯智能挑战赛中flag通过率达到60%左右。

| 属性 | 信息 |
|------|------|
| 队伍名称 | 瀚海星云 |
| 所属单位 | 中国科学技术大学网络信息中心 |
| 项目名称 | sub-agent-autopt |
| GitHub | https://github.com/YANGXU-star/sub-agent-autopt |
| 作者 | 杨旭YANGXU、HackingHUI |
| 比赛成绩 | flag通过率约60% |

## 项目结构

```
sub-agent-autopt/
├── main.py                 # 主入口文件
├── agents/                 # Agent模块
│   ├── coordinator.py     # 协调Agent（主协调者）
│   ├── planner.py         # 规划Agent（负责生成待办清单）
│   └── executor.py        # 执行Agent（负责执行具体任务）
├── config/                # 配置模块
│   └── llm_config.py      # LLM配置管理
├── utils/                 # 工具模块
│   ├── state_manager.py   # 状态管理
│   └── finding_extractor.py  # 发现提取
├── tools/                 # 工具模块（Agent使用的工具）
│   ├── curl_tools.py      # HTTP请求工具（curl封装）
│   └── sandbox_tools.py   # 沙箱工具
└── README.md
```

## Agent架构

系统采用三层Agent架构，各Agent职责明确。

### CoordinatorAgent（协调Agent）

协调Agent是主协调者，负责整体流程控制。其功能包括管理执行循环、协调规划Agent和执行Agent、状态管理和更新、发现提取和汇总、动态重新规划。

### PlannerAgent（规划Agent）

规划Agent负责生成和更新待办清单。其功能包括初始规划（根据目标生成初始待办清单）、动态规划（根据当前状态、发现和历史重新规划）、上下文格式化（为规划准备上下文信息）。

### ExecutorAgent（执行Agent）

执行Agent负责执行具体的测试任务。其功能包括执行单个待办任务、调用工具（sandbox_tools、curl_tools）、返回执行结果。

## 工具模块

### curl_tools.py

提供HTTP请求工具，包含两个主要工具。local_curl是标准化的HTTP请求工具。local_curl_raw是原始curl命令工具，提供更灵活的curl参数传递，适合复杂场景。

### sandbox_tools.py

提供Docker沙箱管理工具，包含四个主要工具。create_sandbox用于创建隔离的Python 3.11 Docker沙箱，返回sandbox_id和挂载路径，自动注册到全局沙箱注册表。write_file用于向沙箱写入文件，支持指定sandbox_id或使用默认沙箱。run_command用于在沙箱内执行命令，支持超时设置和指定执行用户，返回exit_code、stdout、stderr。kill_sandbox用于销毁并清理沙箱，自动从注册表移除。

辅助函数包括set_preset_sandbox_id（设置预设的sandbox_id）、get_preset_sandbox_id（获取当前预设的sandbox_id）、list_sandboxes（列出所有已注册的sandbox_id）、has_sandbox（检查sandbox_id是否存在）。

## 技术亮点

sub-agent-autopt的技术亮点主要体现在以下几个方面。首先是三层Agent架构，协调、规划、执行三层分离，职责清晰。其次是动态规划，支持根据当前状态和发现动态重新规划。第三是Docker沙箱隔离，使用Docker容器提供隔离的执行环境。第四是状态管理，通过state_manager维护执行状态。第五是发现提取，通过finding_extractor提取和汇总测试发现。

## 技术栈

Agent框架使用LangChain，LLM支持DeepSeek等OpenAI兼容API，容器化使用Docker，包管理使用Poetry。
