# 华科金银湖联合战队 - newmapta 技术分析

## 基本信息

华科金银湖联合战队开发了newmapta，一个基于CrewAI框架的ReAct架构渗透测试智能体。该系统强调方法论引导的多Agent定义，结合RAG知识库扩展专业能力边界。

| 属性 | 信息 |
|------|------|
| 队伍名称 | 华科金银湖联合战队 |
| 项目名称 | newmapta |
| GitHub | https://github.com/googlesky/newmapta |

## 框架特点

系统基于CrewAI的ReAct架构构建，采用重方法论引导的多Agent定义，结合RAG知识库扩展专业能力边界。

## 环境配置

### Docker环境

系统使用多个Docker容器提供不同的工具环境。浏览器环境通过start_steel_browsers.sh脚本启动。sqlmap和exec环境使用googlesky/sqlmap镜像，并安装hashcat、php、sshpass等工具。katana环境使用projectdiscovery/katana镜像进行Web爬取。

### 工具集成

系统集成了多种安全工具。ctf-wscan用于目录扫描。browser_use用于浏览器自动化。sqlmap用于SQL注入测试。katana用于Web爬取。

### 库代码修改

系统需要对一些库代码进行修改。browser_use的security_watchdog.py需要修改以允许特定URL导航。crewai的rag_storage.py需要修改以支持自定义持久化目录。

## 项目结构

项目包含多个核心模块。lib/cdppool.py用于CDP连接池管理。lib/config.py用于配置管理。lib/executor.py用于命令执行。lib/knowledge.py用于知识库管理。lib/llm.py用于LLM客户端配置。

## 运行方式

运行系统需要先复制.env.example为.env并配置AI key，然后执行python main.py --url http://xxx启动。清除缓存可以删除~/.local/share/newmapta/和~/.local/share/ctf_*目录。

## 技术亮点

newmapta的技术亮点主要体现在以下几个方面。首先是CrewAI框架，使用CrewAI框架构建多Agent系统，支持ReAct架构。其次是RAG知识库，结合RAG知识库扩展专业能力边界。第三是Docker容器化，使用多个Docker容器提供隔离的工具环境。第四是浏览器自动化，集成browser_use进行浏览器自动化操作。第五是方法论引导，强调方法论引导的Agent定义，而非简单的工具调用。

## 技术栈

Agent框架使用CrewAI，浏览器自动化使用browser_use，容器化使用Docker，知识库使用RAG（向量检索增强生成），支持多种LLM模型。
