# 你说的不队 - PenAgent 技术分析

## 基本信息

你说的不队开发了PenAgent，一个基于Claude Agent SDK的AI自动化渗透测试智能体。该系统采用简洁的单Agent架构，通过Claude模型驱动自动化渗透测试流程。

| 属性 | 信息 |
|------|------|
| 队伍名称 | 你说的不队 |
| 项目名称 | PenAgent |
| GitHub | https://github.com/Aabyss-Team/PenAgent |

## 架构设计

PenAgent采用基于Claude Agent SDK的单Agent架构，核心组件包括CTFChallengeAPI（题目API客户端）、ChallengeManager（赛题状态管理器）和主处理循环。

### CTFChallengeAPI

CTFChallengeAPI类封装了与CTF平台的API交互，提供三个核心方法。get_challenges方法获取赛题列表。get_hint方法获取指定题目的提示。submit_answer方法提交答案。

### ChallengeManager

ChallengeManager类负责赛题状态管理，维护已发现的题目集合、任务活跃状态和上次检查时间。提供mark_task_active方法标记任务活跃状态、is_new_challenge方法检查是否为新题目、is_task_active方法检查任务是否活跃、add_discovered方法添加已发现的题目。

### 主处理循环

系统采用异步循环架构，check_and_update_tasks函数定期检查题目状态，发现新题目或需要重启的题目时启动处理任务。process_single_challenge函数处理单个题目，构建系统提示并调用Claude Agent进行渗透测试。

## 系统提示设计

系统提示经过精心设计，包含以下关键要素。在角色定义方面，将Agent定位为专业的渗透测试工程师。在环境说明方面，明确Linux系统包含Kali工具集。在任务说明方面，提供靶场信息、提示获取命令和flag提交命令。

系统提示还包含丰富的渗透技巧指导，涵盖目录与文件探测（gobuster、dirb、ffuf）、Web服务器与框架漏洞扫描（nikto、wpscan、joomscan）、注入漏洞探测（sqlmap、xsser）、通用漏洞框架（metasploit）、漏洞扫描（nuclei）、HTTP请求测试（curl）、密码爆破（hydra）、流量分析（wireshark）和密码破解（john）等。

## 工作流程

系统的工作流程包括以下步骤。首先程序启动后进入监控循环。然后定期检查题目列表（默认60秒间隔）。发现新题目或未解决且任务已结束的题目时，启动处理任务。处理任务构建系统提示，调用Claude Agent进行渗透测试。Agent执行渗透测试，获取flag并提交。

## 技术亮点

PenAgent的技术亮点主要体现在以下几个方面。首先是Claude Agent SDK，使用Anthropic的Claude Agent SDK，简化Agent开发。其次是异步并发，使用asyncio实现异步处理，支持多题目并发。第三是自动重启，对未解决且任务已结束的题目自动重启处理。第四是丰富的渗透技巧，系统提示包含详细的工具使用指导。第五是容错机制，多层异常处理和自动重启机制确保系统稳定运行。

## 技术栈

Agent SDK使用Claude Agent SDK（claude_agent_sdk），异步框架使用asyncio，HTTP客户端使用requests。
