# sickhack 队伍 - SickHackShark 技术分析

## 基本信息

sickhack队伍来自绿盟科技，在腾讯云黑客松智能渗透挑战赛中获得第10名。该队伍开发了SickHackShark，一个基于AI Agent智能体的CTF网络安全竞赛自动化工具平台，采用多Agent智能体架构，能够自动完成Web安全测试任务的全过程。

| 属性 | 信息 |
|------|------|
| 队伍名称 | sickhack |
| 所属单位 | 绿盟科技 |
| 排名 | 第10名 |
| 项目名称 | SickHackShark |
| GitHub | https://github.com/SickHackPark/SickHackShark |

## 架构设计

SickHackShark采用模块化的多Agent架构，通过主Agent协调多个专业化子Agent完成复杂的安全测试任务。

### 主要组件

系统由四个核心Agent组成。主Agent负责协调整个任务流程，调度各个子Agent执行专门任务。web-scout-subagent负责Web应用的信息收集和侦察，收集端点、参数、潜在漏洞等信息，并输出侦察报告供其他Agent使用。vuln-find-dig-and-flag-subagent负责漏洞挖掘、利用和flag获取，一次专注于一种漏洞类型。flag-exploit-subagent专门用于已知漏洞的flag获取，在其他Agent确认漏洞但未找到flag时调用。

### 核心功能

系统具备自动化Web应用侦察和信息收集能力，支持多种Web漏洞的自动检测和利用（如SQL注入、XSS、命令注入等），提供智能flag搜索和验证功能，集成Kali Linux工具集，并支持报告生成和结果管理。

## 基于YAML的灵活Agent编排

SickHackShark的一大技术亮点是通过YAML配置文件实现灵活的Agent编排。这种设计具有多项核心优势。

在可定制化方面，系统可根据不同CTF题目类型自由组合所需Agent，支持个性化任务配置。在模块化架构方面，各Agent职责分明，独立开发维护，支持并行处理和动态调度。在维护升级方面，配置驱动的设计使系统行为调整无需重新编译，支持版本管理和快速回滚。在中间件支持方面，系统内置模型降级、上下文管理等中间件，提升系统稳定性和容错能力。

### 配置结构

配置文件主要包含四个部分。system_prompt定义主Agent的系统提示，包含整体任务指导和规则说明。filesystem_backend配置文件系统后端，包括路由路径、根目录和虚拟模式设置。middleware配置中间件，用于处理Agent的上下文管理和优化。subagents定义子Agent的配置，每个子Agent包含名称、描述、系统提示、工具列表和专用中间件配置。

### 中间件系统

系统提供多种中间件类型。ModelFallbackMiddleware是模型降级中间件，当主模型无法正常工作时自动切换到备用模型。ImportantNotesMiddleware是重要笔记中间件，用于提取和保存关键信息。ContextEditingMiddleware是上下文编辑中间件，用于管理和优化Agent的上下文长度，其中包含LongChainWakeUp长链唤醒机制（防止在长任务链中丢失重要信息）和ClearToolUsesEdit工具使用清理机制（定期清理历史工具调用记录以控制上下文长度）。

## 项目结构

```
.
├── kali_server                   # Kali Linux工具服务端
│   ├── Dockerfile                # Kali服务Docker镜像配置
│   └── kali_server_fastapi.py    # Kali工具FastAPI服务实现
├── src/agent                     # Agent核心代码目录
│   ├── common                    # 通用配置和工具
│   ├── composer                  # Agent编排器
│   │   └── ctf_deepagents.yaml   # CTF任务默认配置文件
│   ├── middleware                # 中间件组件
│   ├── models                    # 数据模型定义
│   └── tools                     # Agent可用工具
├── Dockerfile                    # 主服务Docker镜像配置
├── docker-compose.yml            # Docker服务编排配置
└── langgraph.json                # LangGraph配置文件
```

## 技术亮点

SickHackShark的技术亮点主要体现在以下几个方面。首先是YAML配置驱动，通过声明式配置定义Agent行为，无需修改代码即可调整系统行为。其次是多Agent协同，主Agent与多个专业化子Agent协同工作，各司其职。第三是中间件架构，提供模型降级、上下文管理、长链唤醒等中间件，增强系统稳定性。第四是Kali工具集成，通过FastAPI服务封装Kali工具，提供统一的调用接口。第五是LangGraph集成，使用LangGraph框架构建Agent图，支持复杂的任务流程编排。

## 技术栈

后端采用Python开发，使用FastAPI框架，Agent框架基于LangGraph，容器化使用Docker和Docker Compose，工具环境基于Kali Linux，支持LangSmith进行追踪和调试。
