# yhy 队伍 - CHYing Agent 技术分析

## 基本信息
- 队伍名称：yhy
- 排名：第9名
- 项目名称：CHYing Agent
- GitHub：https://github.com/yhy0/CHYing-agent
- 开发方式：AI辅助AI（Claude帮助实现代码）

## 核心亮点：AI 构建 AI Agent

ChYing Agent 是一个「AI 辅助 AI」的产物。作为选手，负责提供专业的渗透思路和架构设计，而具体的代码实现，大部分由 Claude 根据比赛文档和设计指令完成。

## 架构设计

### 双 Agent 协作架构：顾问与主攻手的分工

设计了一个**顾问 Agent**——它不直接执行命令，只负责提供建议。

#### 设计原因
- 对话轮次一多、上下文一长，模型开始幻觉、夸大、脑补不存在的接口和结果
- 模型会越来越自信，但不一定越来越正确

#### 顾问的介入时机
1. **任务开始时**：顾问提供初始建议，避免盲目尝试
2. **连续失败时**：失败 3 次、6 次、9 次时，顾问重新评估策略
3. **定期咨询**：每 5 次尝试定期咨询，防止主攻手陷入思维定式
4. **主动求助**：LLM 自己意识到卡住了，主动请求顾问介入

### 核心思想：「不完全信任」的工程哲学

```
完全信任 LLM   → 系统脆弱，一个幻觉就崩溃
完全不信任 LLM → 系统僵化，失去 AI 的灵活性
不完全信任 LLM → 系统稳健，AI 能力 + 确定性兜底
```

## 工具体系：让 LLM 自己选武器

设计了三类工具：

1. **Kali Docker 工具**：sqlmap、ffuf、curl 等专业渗透工具，开箱即用
2. **Python 脚本执行**：在 Docker 里执行 Python，LLM 想写什么代码就写什么代码
3. **API 工具**：负责题目管理和记忆系统

### 极简工具设计原则

三个工具就够了：
1. `execute_command` — 执行任何 Kali 命令
2. `execute_python_poc` — 执行任何 Python 代码
3. `submit_flag` — 提交答案

设计原则：**给 LLM 最少的选择，但每个选择都足够强大**。

- 工具越多 → LLM 需要匹配的模式越复杂 → 出错概率越高
- 工具越少 → LLM 的决策空间越清晰 → 执行越稳定

## 实验性探索：动态角色互换

当一次攻击失败，单纯的重试可能无效。设计了「角色互换」机制：
- 第一轮 DeepSeek 主攻失败
- 第二轮换 MiniMax 主攻、DeepSeek 退居幕后做参谋
- 反复轮换

## 技术栈
- 语言：Python 97.4%
- 框架：LangGraph
- 模型：DeepSeek、MiniMax
- 环境：Kali Docker

## 成功经验总结
1. 顾问 Agent 的设计：模拟日常使用 LLM 的习惯——从不盲信 LLM 的回答
2. 极简的工具设计：放弃复杂封装，直接让 LLM 用 Kali 工具
3. 把主动权交给 LLM：让它自己规划攻击步骤
4. 兜底策略：在关键时刻救回了多道题

## 当前问题
主 Agent 的 Prompt 里混杂了太多东西——解题策略、Python 规范、Docker 用法、漏洞知识，加重了认知负担。
