# CHYing-Agent DeepWiki深度分析

## 项目概述

CHYing-agent是一个AI驱动的自主CTF渗透测试智能体，使用大型语言模型（LLM）自动发现和利用CTF挑战中的漏洞。该系统是为腾讯云黑客松CTF比赛开发的，最终获得**第9名**。

Agent在无人干预的情况下运行，通过LLM推理做出所有战术决策，同时在隔离的Docker和沙箱环境中执行命令。与传统的静态安全工具不同，CHYing-agent根据挑战响应、之前的失败和来自顾问Agent的战略指导动态调整其方法。

## 关键特性

| 方面 | 实现 |
|------|------|
| **执行模式** | 双模式：立即解决（main.py）和延迟提示解决（main_with_hint.py） |
| **Agent架构** | 多Agent协作：主攻手 + 顾问Agent |
| **工具哲学** | 最小工具集（3个核心工具）+ 最大灵活性 |
| **LLM策略** | 主模型（DeepSeek）+ 备用模型（SiliconFlow: Kimi K2, GLM-4.6） |
| **执行环境** | Docker（Kali Linux）+ Microsandbox（Python隔离） |
| **编排框架** | LangGraph with ToolNode pattern |
| **并发** | 最多8个并发挑战解决任务 |

## 系统架构

系统遵循分层架构：

1. **入口点** - 两种执行模式：`main.py`和`main_with_hint.py`
2. **编排层** - `chying_agent/`模块中的核心逻辑管理任务生命周期
3. **Agent执行** - 在`chying_agent/graph.py`中定义的LangGraph状态机
4. **工具系统** - `chying_agent/tools/`目录中的LangChain工具
5. **执行环境** - `chying_agent/executor/`中的隔离执行器
6. **外部服务** - LLM和可观测性的第三方API

### 核心组件

| 组件 | 代码实体 | 功能 |
|------|----------|------|
| **调度器** | `Scheduler`类 | run_scheduler(), dynamic_slot_filling() |
| **任务启动器** | `TaskLauncher`类 | launch_task() |
| **任务管理器** | `ChallengeTaskManager`类 | active_tasks, completed_tasks, retry_counts |
| **重试策略** | `RetryStrategy`类 | get_llm_pair(), format_failure_history() |
| **挑战解决器** | solve_single_challenge() | 单个挑战的解决逻辑 |

## 双执行模式

CHYing-agent以两种互补模式运行，旨在最大化挑战解决率：

### 模式对比

| 方面 | 正常模式（main.py） | 提示模式（main_with_hint.py） |
|------|---------------------|-------------------------------|
| **时机** | 立即（t=0） | 延迟（t+2小时） |
| **数据源** | 仅挑战描述 | 提示 + 尝试历史 |
| **LLM模型** | DeepSeek ↔ MiniMax角色互换 | Kimi K2 + GLM-4.6（备用策略） |
| **历史分析** | 无 | LLM驱动的失败元分析 |
| **目的** | 第一轮快速解决 | 第二轮战略突破 |

提示模式作为"兜底策略"，利用三个关键优势：
1. **挑战提示** - 访问官方提示（有扣分惩罚）
2. **历史分析** - LLM分析之前失败的尝试以提取模式
3. **更强模型** - 使用SiliconFlow更强大的模型（Kimi K2, GLM-4.6）

## 核心设计哲学：不完全信任

系统体现了一个核心工程哲学：对LLM能力的**"不完全信任"**。

### 信任谱系

```
完全信任 LLM   → 系统脆弱，一个幻觉就崩溃
完全不信任 LLM → 系统僵化，失去AI的灵活性
不完全信任 LLM → 系统稳健，AI能力 + 确定性兜底
```

这种设计哲学解决了一个基本观察：LLM在较长对话中表现出越来越高的信心，但不一定越来越正确。系统实现了多重保障：

### 保障机制

| 机制 | 说明 |
|------|------|
| **双Agent协作** | 顾问Agent提供战略审查，无工具访问权限，防止单模型隧道视野 |
| **自动FLAG提交** | tool_node()中的回退机制，检测工具输出中的FLAG模式，如果LLM未能调用submit_flag则自动提交 |
| **智能失败检测** | LLM驱动的语义分析达到95%+准确率，vs关键词匹配的60-70% |
| **干预触发器** | 顾问在关键时刻介入：任务开始、连续3/6/9次失败、每5次尝试、或主动请求 |
| **资源限制** | 硬超时和尝试上限防止无限循环 |

自动FLAG提交特别重要：它捕获常见的LLM工具调用错误，即Agent找到FLAG但使用execute_python_poc打印而不是调用submit_flag。

## 极简工具集

系统只提供**3个核心工具**，而不是数十个专用MCP包装器：

| 工具 | 实现 | 用途 | 环境 |
|------|------|------|------|
| **execute_command** | chying_agent/tools/shell.py | 执行任何shell命令 | Docker (Kali Linux) |
| **execute_python_poc** | chying_agent/tools/shell_enhanced.py | 执行任何Python代码 | Microsandbox/Docker |
| **submit_flag** | chying_agent/tools/competition_api_tools.py | 提交挑战答案 | Competition API |

### 设计原理

这种"少即是多"的方法信任LLM对标准渗透测试工具（nmap, sqlmap, metasploit, ffuf, curl, hydra, john）的知识，而不是为每个工具创建包装函数。

- `execute_command`工具提供对Kali Linux工具链的无限访问
- `execute_python_poc`启用多步利用逻辑、自定义payload构建和复杂响应解析

**设计理念**：更少的工具 → 更清晰的决策空间 → 更稳定的执行。复杂性从"工具选择"转移到"工具知识"，利用LLM训练数据。

## 并发任务执行

Scheduler类实现动态槽位填充：
- MAX_CONCURRENT_TASKS=8个并行挑战解决任务
- 动态调度和任务管理

## 双Agent协作详解

### 主攻手Agent (Main Attacker)
- 使用DeepSeek或Kimi K2模型
- 负责实际的渗透测试执行
- 调用工具进行攻击

### 顾问Agent (Consultant)
- 使用MiniMax或GLM-4.6模型
- 不直接执行任何操作
- 在关键时刻提供战略建议

### 介入时机
1. **任务开始时** - 提供初始建议
2. **连续失败时** - 3/6/9次失败时强制介入
3. **定期咨询** - 每5次尝试
4. **主动求助** - 主攻手请求帮助时

## 技术栈

- **编排框架**: LangGraph with ToolNode pattern
- **LLM提供商**: DeepSeek, SiliconFlow (Kimi K2, GLM-4.6), MiniMax
- **执行环境**: Docker (Kali Linux), Microsandbox
- **可观测性**: Langfuse
- **构建系统**: pyproject.toml

## 关键成功因素

1. **顾问Agent设计** - 模拟日常使用LLM的习惯，从不盲信LLM的回答
2. **极简工具设计** - 放弃复杂封装，直接让LLM用Kali工具
3. **把主动权交给LLM** - 让它自己规划攻击步骤
4. **兜底策略** - 在关键时刻救回了多道题
