# DawnEdg3 队伍 - Cruiser 技术分析

## 基本信息

DawnEdg3队伍来自香港城市大学信工所，开发了Cruiser，一个面向CTF Web挑战的AI Agent自动化扫描工具。该工具采用基于LangChain的ReAct架构，支持多会话并发扫描和关键信息共享。

| 属性 | 信息 |
|------|------|
| 队伍名称 | DawnEdg3 |
| 所属单位 | 香港城市大学信工所 |
| 项目名称 | Cruiser |
| GitHub | https://github.com/CyberSecurityScience/Cruiser_public |

## 核心架构

Cruiser采用基于LangChain的Agent架构，核心组件包括LLM客户端、工具系统、提示模板和对话历史管理。

### 多会话并发

系统支持多会话并发扫描模式。单会话模式使用中心题目获取器获取题目并下发给会话执行。多会话并发模式启动子进程并行扫描，实时将每个会话的输出打印到标准输出，谁先输出含有flag的JSON就停止所有会话。

### 关键信息共享

系统实现了跨会话的关键信息共享机制。_write_shared_info函数将关键信息写入共享文件（带去重检查），关键信息包括默认口令、新路径、新API等。_read_shared_info函数读取共享的关键信息文件，默认只返回最后5条。_is_info_duplicate函数使用智能匹配检查关键信息是否已存在，避免重复写入相似信息。

### 对话历史管理

系统维护会话内对话历史（内存态，仅当前进程生命周期）。_format_conversation_context函数格式化对话上下文，适度截断避免超长。支持上下文超限错误检测和处理。

### 安全工具发现

系统启动时会调用list_security_tools_tool获取当前环境可用的命令行安全工具，并生成简短概览。概览会被注入到system prompt，帮助模型更好地理解环境能力。

## 工作流程

系统的工作流程包括以下步骤。首先获取题目列表，按难度排序选择最简单的题目。然后为会话创建独立工作空间。接着运行自动扫描，使用ReAct循环进行推理和工具调用。最后输出结果，包含flag的JSON格式。

## 技术亮点

Cruiser的技术亮点主要体现在以下几个方面。首先是多会话并发，支持多个会话并行扫描同一题目，提高解题效率。其次是关键信息共享，跨会话共享发现的关键信息，避免重复探索。第三是智能去重，使用多种方法检测重复信息，包括完全匹配、关键部分匹配和相似度计算。第四是环境感知，启动时自动发现可用安全工具，注入到系统提示中。第五是上下文管理，支持对话历史截断和上下文超限错误处理。

## 命令行参数

| 参数 | 说明 |
|------|------|
| --target | 扫描目标地址 |
| --max-steps | AI扫描最大步数（0=无限） |
| --quiet | 静默中间输出，仅保留最终JSON |
| --sessions | 并发工作会话数量（>=1） |
| --default-timeout | run_command默认超时（秒） |
| --max-timeout | run_command超时上限（秒） |
| --hint | 题目提示 |
| --challenge-code | 题目代码 |

## 技术栈

Agent框架使用LangChain，LLM客户端支持OpenAI兼容API，工具系统包括安全工具发现和命令执行，数据存储使用文件系统（reports目录）。
