# ai小分队 队伍 - XBow Competition 技术分析

## 基本信息

ai小分队来自绿盟科技，在腾讯云黑客松智能渗透挑战赛中获得第7名和优秀奖。该队伍开发了一套完整的AI Agent自动化XBOW解题方案，结合MCP服务器和智能CLI客户端，实现自主渗透测试。

| 属性 | 信息 |
|------|------|
| 队伍名称 | ai小分队 |
| 所属单位 | 绿盟科技 |
| 排名 | 第7名 |
| 获奖情况 | 优秀奖 |
| 项目名称 | XBow Competition |
| GitHub | https://github.com/m-sec-org/xbow-competition |

## 项目架构

该项目由两个核心组件组成，采用分层架构设计：

### 架构图

```
┌─────────────────────┐
│   Kimi CLI Agent    │  ← 用户交互层
│  (AI 决策引擎)       │
└──────────┬──────────┘
           │ MCP 协议
           ↓
┌─────────────────────┐
│  XBow MCP Server    │  ← 能力抽象层
│  (工具和知识库)      │
└──────────┬──────────┘
           │
           ├→ XBow Platform (真实/模拟)
           ├→ Kali Container (工具执行)
           └→ Knowledge Base (技术文档)
```

### 组件一：ez-xbow-platform-mcp（MCP服务器）

这是一个模型上下文协议服务器，提供XBOW挑战管理、知识库、Kali容器等能力，作为AI Agent与XBow平台之间的桥梁。服务器支持本地模拟测试和真实平台对接，采用Go语言开发。

核心功能包括挑战管理（列出、尝试和提交CTF挑战的解决方案）、知识库（内建涵盖9种漏洞类别的CTF技术文档）、持久化Kali容器（在隔离环境中执行安全工具）、尝试历史（通过自动笔记管理跨会话跟踪和共享发现）以及多种协议支持（stdio、SSE和HTTP/2流模式）。

### 组件二：kimi-cli-for-xbow（CTF专用AI Agent CLI）

这是基于Kimi CLI深度定制的自动解题客户端，支持多种AI模型（DeepSeek、通义千问等），通过Daemon模式实现无人值守自动解题。该组件使用Python 3.13+开发，采用uv包管理器。

主要特性包括自定义模型支持、专用Agent模式（针对CTF竞赛优化的ctfer、security、security_beta三种Agent）、Daemon自动解题、命令执行防沉迷机制、Session隔离以及Shell集成。

## MCP Server工具集

| 工具 | 描述 |
|------|------|
| list_challenges | 获取当前阶段的挑战，包括难度和目标信息 |
| do_challenge | 标记挑战为进行中，并增加尝试计数器 |
| get_challenge_hint | 检索提示（会扣除分数） |
| submit_answer | 提交Flag并接收评分结果 |
| get_ctf_skill | 访问技术文档（xss、sql、ssti、ssrf、idor、xxe、lfi、codei、afr&pt） |
| write_challenge_note | 保存发现和尝试记录，供将来参考 |
| read_challenge_note | 查看历史笔记（每9次尝试后自动重置） |
| kail_terminal | 在持久化Kali容器中执行命令 |
| get_terminal_history | 通过ID检索命令执行结果 |

## 技术亮点

该项目在多个方面展现了技术创新。首先是MCP协议应用，采用标准化的Model Context Protocol实现AI与工具的解耦，这种设计使得系统具有良好的可扩展性和可维护性。

其次是知识库驱动的设计理念，内置9种漏洞类别的技术文档，涵盖XSS、SQL注入、SSTI、SSRF、IDOR、XXE、LFI、代码注入和任意文件读取等常见漏洞类型，为AI提供了丰富的领域知识支持。

第三是多实例并行解题能力，支持在不同目录同时运行多个实例，每个实例可以专注于不同类型的题目，显著提升了解题效率。

第四是Session隔离机制，每个工作目录自动维护独立的session，确保不同任务之间的上下文不会相互干扰。

最后是防沉迷保护机制，防止AI陷入无限循环和过度命令执行，提高了系统的稳定性和可靠性。

## 技术栈

服务端采用Go 1.24.7+开发，客户端使用Python 3.13+，容器化方面使用Docker和Kali Linux镜像，支持的AI模型包括DeepSeek和通义千问等OpenAI兼容API。
