# Pachinko 队伍 - hackthon_demo 技术分析

## 基本信息

Pachinko队伍来自社会组织，开发了一个基于AutoGen框架的CTF自动化解题系统。该系统采用单Agent架构，通过Docker容器化的Kali环境执行安全测试任务。

| 属性 | 信息 |
|------|------|
| 队伍名称 | Pachinko |
| 所属单位 | 社会组织 |
| 项目名称 | hackthon_demo |
| GitHub | https://github.com/Ghr07h/hackthon_demo |

## 技术架构

该项目基于Microsoft AutoGen框架构建，采用单Agent架构设计。系统的核心是一个名为"Hacker"的AssistantAgent，配合CodeExecutorAgent执行代码和命令。

### 核心组件

系统主要由以下组件构成。Hacker Agent是主要的决策Agent，负责分析题目、制定攻击策略和调用工具。Code Executor Agent负责在Docker化的Kali环境中执行Python脚本和命令行工具。Knowledge Base使用ChromaDB向量数据库存储和检索安全知识，支持语义搜索。

### 工具系统

系统提供三个核心工具。agent_tool_use_python_or_command用于在Kali操作系统的攻击机中执行Python脚本或命令行工具。agent_tool_save_flag用于保存发现的Flag。agent_tool_task_finish用于结束任务。

## 模型配置

系统支持多种大语言模型，并为不同模型配置了优化参数：

| 模型 | 温度 | Top-P | 特殊配置 |
|------|------|-------|----------|
| qwen3-max | 0.3 | 0.9 | - |
| qwen3-coder-plus | 0.3 | 0.9 | - |
| qwen3-max-preview | 0.2 | 0.8 | enable_thinking |
| qwen-plus | 0.2 | 0.8 | enable_thinking |
| deepseek-v3.2-exp | 0.0 | 0.9 | - |
| deepseek-r1 | 0.0 | 0.9 | - |

系统还支持通过在模型名称后添加"/think"后缀来启用思考模式。

## 系统提示设计

Hacker Agent的系统提示经过精心设计，包含以下关键要素。在角色定义方面，将Agent定位为CTF比赛选手，精通网络安全和计算机相关知识，擅长使用Kali中的命令行工具。在任务说明方面，明确目标是探索目标URL，发现和利用漏洞，获取Flag。在环境约束方面，说明处于隔离网络中，不能联网安装工具。

系统提示还包含多项优秀实践指导，包括将问题分解成更小的步骤、有条不紊地一次测试一个组件、连续失败后反思自己的失误、遵循题目提示解题、使用curl查看网页返回中的线索等。

## 终止条件

系统设置了多种终止条件以确保任务能够正常结束。MaxMessageTermination限制最大消息数为200条。TimeoutTermination设置超时时间为1200秒（20分钟）。ExternalTermination支持外部终止信号。FunctionCallTermination在调用task_finish函数时终止。

## 代码执行环境

系统使用Docker容器化的Kali Linux环境执行代码和命令。DockerCommandLineCodeExecutor配置了自定义镜像（my_kali:v1.0）、工作目录、自动清理和180秒超时。Code Executor Agent使用专门的qwen3-coder-plus模型处理代码格式化，将用户输入的代码或命令转换为标准的Markdown代码块格式。

## 技术亮点

Pachinko的方案具有几个显著特点。首先是AutoGen框架应用，利用Microsoft AutoGen框架构建Agent系统，代码简洁清晰。其次是Docker隔离执行，使用Docker容器化的Kali环境执行命令，确保安全性和可重复性。第三是知识库集成，使用ChromaDB向量数据库存储安全知识，支持语义检索。第四是多模型支持，支持多种大语言模型，并针对不同模型优化参数配置。第五是思考模式，支持通过"/think"后缀启用模型的思考模式，增强推理能力。

## 技术栈

Agent框架使用Microsoft AutoGen，向量数据库使用ChromaDB，容器化环境使用Docker和Kali Linux，支持的LLM包括Qwen系列和DeepSeek系列，嵌入模型使用text-embedding-v4。
