# Antix 队伍 - tinyctfer 技术分析

## 基本信息
- 队伍名称：Antix
- 所属单位：chainreactors
- 排名：第4名
- 项目名称：tinyctfer
- GitHub：https://github.com/chainreactors/tinyctfer
- 技术文章：https://mp.weixin.qq.com/s/jT4poWZ4Gfu3faXvul07HA
- PPT：https://wiki.chainreactors.red/blog/2025/12/01/intent_is_all_you_need/
- 演讲视频：https://www.bilibili.com/video/BV1z12eBkETz

## 项目概述

tinyctfer 是腾讯云黑客松-智能渗透挑战赛第4名的核心代码，采用 Claude Code 作为 SubAgent 进行 CTF 解题。

## 核心特性

### Meta-Tooling 实现
- 使用 Claude Code 作为核心 Agent
- 支持 Anthropic 兼容 API
- 沙盒环境运行（Docker）

### 调度和运行机制
- 任务并行处理
- 题目优先排序
- 多次失败后提示词动态变换
- hint 获取策略
- LLM 和 Agent switch 机制

## 技术架构

### 沙盒环境
- 使用 Docker 容器作为沙盒
- 支持 VNC 服务，可直观查看解题步骤
- 比赛时多容器并行，为节省性能不开UI

### Claude Code SubAgent
- 目前设定只能用于解CTF
- 唯一目标就是找到 flag
- 后续计划支持自定义的安全测试任务甚至通用任务

## 使用方式

```bash
# 下载沙盒镜像
docker pull ghcr.io/l3yx/sandbox:latest

# 启动解题
uv run --env-file .env tinyctfer.py --ctf <CTF_URL> --workspace workspace
```

## 技术亮点

1. **Meta-Tooling**：让 AI 自己选择和使用工具
2. **Claude Code 集成**：利用 Claude 的代码能力
3. **动态提示词**：多次失败后自动调整策略
4. **并行处理**：多容器并行解题
5. **可视化调试**：VNC 服务支持实时查看

## 设计理念

标题 "Intent is All You Need" 表明其核心理念：
- 让 AI 理解意图
- 让 AI 自主选择工具和方法
- 减少人工干预

## 待优化方向

- Meta-Tooling 的实现还有非常大的优化空间
- 代码需要重构整理
- 计划开源正式版本
