# BinX 队伍 - tinyctfer 技术分析

## 基本信息

BinX队伍来自广州大学，开发了tinyctfer，一个基于Claude Code的CTF自动解题工具。该项目在腾讯云黑客松智能渗透挑战赛中获得第4名。

| 属性 | 信息 |
|------|------|
| 队伍名称 | BinX |
| 所属单位 | 广州大学 |
| 项目名称 | tinyctfer |
| GitHub | https://github.com/l3yx/tinyctfer |
| 排名 | 第4名 |
| 相关资料 | [文章](https://mp.weixin.qq.com/s/jT4poWZ4Gfu3faXvul07HA)、[PPT](https://wiki.chainreactors.red/blog/2025/12/01/intent_is_all_you_need/)、[演讲视频](https://www.bilibili.com/video/BV1z12eBkETz) |

## 项目概述

tinyctfer是一个基于Claude Code SubAgent的CTF自动解题工具，采用Meta-Tooling理念，使用Docker沙盒环境执行渗透测试任务。

## 技术架构

### 核心理念：Intent is All You Need

项目采用"意图即一切"的设计理念，通过Claude Code SubAgent理解用户意图并自主完成CTF解题任务。

### Docker沙盒环境

系统使用预构建的Docker镜像（l3yx/sandbox）提供隔离的执行环境，支持VNC服务可视化查看解题步骤。

### Claude Code SubAgent

系统使用Claude Code作为SubAgent，目前设定比较耦合，只能用于解CTF，唯一目标就是找到flag。

## 比赛时的高级特性

比赛时的调度和运行代码包含多项高级特性。任务并行支持多容器并行执行。题目优先排序对题目进行智能排序。动态提示词变换在多次失败后动态调整提示词。hint获取策略智能获取题目提示。LLM和Agent switch机制支持切换不同的LLM和Agent。

## 使用方法

首先下载沙盒镜像：
```bash
docker pull ghcr.io/l3yx/sandbox:latest
docker tag ghcr.io/l3yx/sandbox:latest l3yx/sandbox:latest
```

然后创建.env文件并填入LLM Key（支持任意Anthropic兼容API）：
```bash
cp .env.example .env
```

最后指定CTF题目地址和工作目录启动：
```bash
uv run --env-file .env tinyctfer.py --ctf http://xxx --workspace workspace
```

## 技术亮点

tinyctfer的技术亮点主要体现在以下几个方面。首先是Meta-Tooling理念，通过高层次的意图理解驱动自动化解题。其次是Claude Code集成，利用Claude Code的强大能力进行自主探索和推理。第三是Docker沙盒隔离，提供安全隔离的执行环境。第四是VNC可视化，支持实时查看解题步骤。第五是动态策略调整，支持提示词动态变换和hint获取策略。

## 未来计划

项目计划支持自定义的安全测试任务甚至通用任务，对Meta-Tooling的实现进行优化，重构代码并开源正式版本。

## 技术栈

Agent框架使用Claude Code，容器化使用Docker，包管理使用uv，LLM支持Anthropic兼容API（如智谱AI GLM-4.6）。
