# xjtuHunter 队伍 - ctfSolver 技术分析

## 基本信息
- 队伍名称：xjtuHunter
- 所属单位：西安交通大学
- 排名：第2名
- 项目名称：ctfSolver
- GitHub：https://github.com/passer-W/ctfSolver
- 核心维护者：九暑（passerW）

## 项目概述

ctfSolver 是一款基于人工智能的 CTF（Capture The Flag）自动解题平台，依托大语言模型的自主探索与推理能力，精准攻克 CTF 赛题中复杂的漏洞利用挑战，能够提供覆盖多场景、多类型漏洞的端到端自动化解题方案。

## 技术架构

### 多Agent协同工作架构

采用五大核心Agent，各司其职又协同配合：

1. **explorer（页面探索Agent）**：自动爬取和分析目标网站的页面结构、JavaScript文件和API端点
2. **scanner（漏洞扫描Agent）**：支持XSS、SQL注入、命令注入、LFI、IDOR等多种常见Web漏洞检测
3. **solutioner（解题Agent）**：根据题目场景自动生成利用脚本和漏洞利用思路
4. **executor（命令执行Agent）**：执行命令和脚本
5. **actioner（动作执行Agent）**：执行具体动作

### 系统架构
- **前后端分离**：Flask后端提供API服务，前端界面提供友好的任务管理和监控
- **AI驱动决策**：利用大语言模型分析漏洞、生成利用思路和代码

## 核心能力

1. **智能页面探索**：自动爬取和分析目标网站的页面结构
2. **多维度漏洞扫描**：支持多种常见Web漏洞检测
3. **跨场景漏洞利用**：提供不同场景的上下文记忆，组合多类型漏洞解决复杂CTF问题
4. **自动化漏洞利用**：根据漏洞类型自动生成并执行利用脚本

## 工具扩展机制

内置工具：
- Base64解码
- JSFuck解码
- PHP Filter Chain生成
- HTTP请求工具
- Python代码执行
- Shell命令执行
- 支持自定义工具扩展

## 并发处理优化

- 多线程并发页面探索和漏洞扫描
- 异步任务处理，提升整体解题效率
- 线程安全的结果管理和数据处理

## 项目结构

```
├── agent/              # 核心智能体引擎
│   ├── addons/         # 工具扩展模块
│   ├── agents/         # 多Agent功能模块
│   ├── config/         # 配置文件和资源（知识库）
│   ├── tasks/          # 任务存储目录
│   ├── utils/          # 实用工具函数
│   ├── contest_hunter.py # 比赛自动化工具
│   └── flaghunter.py   # 主要Flag捕获工具
├── server/             # 服务器端
│   ├── backend/        # Flask后端服务
│   ├── frontend/       # 前端界面
│   └── docker-compose.yaml # Docker部署配置
```

## 工作流程

1. **页面探索**：自动爬取目标网站的所有页面
2. **漏洞检测**：对每个页面进行漏洞扫描
3. **漏洞利用**：对发现的漏洞尝试利用
4. **Flag提取**：从响应中识别并提取Flag提交至后端

## 技术栈

- Python 3.8+
- Flask（后端服务）
- Celery（异步任务处理）
- SQLite3（数据存储）
- Redis（消息代理）
- Docker（部署）
- DeepSeek / 腾讯云 API（LLM）

## 技术亮点总结

1. **多Agent协同**：五个专业化Agent分工明确，协同工作
2. **知识库驱动**：内置POC脚本、Payload模板、知识库文件
3. **工具可扩展**：支持自定义工具扩展
4. **并发优化**：多线程并发处理提升效率
5. **前后端分离**：提供友好的Web界面进行任务管理
