# 腾讯智能渗透挑战赛优胜队伍深度分析：sickhack (SickHackShark)

## 1. 队伍概况

- **队伍名称**: sickhack
- **所属单位**: 绿盟科技 (NSFOCUS)
- **最终排名**: **第十名**
- **开源项目**: [SickHackShark](https://github.com/SickHackPark/SickHackShark)

## 2. 核心架构：基于YAML配置驱动的多Agent编排体系

`sickhack` 队伍的 `SickHackShark` 项目是本次比赛中**工程化和配置化**做得最出色的项目之一。它同样来自绿盟科技，但与`ai小分队`的MCP架构不同，`SickHackShark`选择了一条更为主流但同样精巧的技术路线：**基于LangGraph构建，通过声明式的YAML文件来动态编排一个多Agent协同系统**。

```mermaid
graph TD
    A[主控程序] -- "加载ctf_deepagents.yaml" --> B{Agent编排器 (Composer)};
    B -- "创建主Agent和子Agent" --> C[主Agent];
    B -- "创建主Agent和子Agent" --> D[web-scout-subagent];
    B -- "创建主Agent和子Agent" --> E[vuln-find-dig-and-flag-subagent];
    B -- "创建主Agent和子Agent" --> F[flag-exploit-subagent];

    C -- "调度" --> D;
    C -- "调度" --> E;
    C -- "调度" --> F;

    subgraph "子Agent集群"
        D -- "执行信息搜集" --> G{工具集};
        E -- "执行漏洞挖掘" --> G;
        F -- "执行Flag获取" --> G;
    end

    subgraph "工具与环境"
        G -- "通过FastAPI调用" --> H[Kali Server (Docker)];
    end

    H -- "返回结果" --> G;
    G -- "返回结果" --> D;
    G -- "返回结果" --> E;
    G -- "返回结果" --> F;
    D & E & F -- "结果上报" --> C;
```

- **Agent编排器 (Composer)**: 这是系统的启动核心。它负责读取核心配置文件 `ctf_deepagents.yaml`，并根据文件中的定义，动态地创建和组装主Agent、子Agent以及它们所需的工具和中间件。
- **主Agent**: 扮演“项目经理”的角色，负责协调整个任务流程，根据总体目标和当前进展，决定调用哪个子Agent来执行下一步任务。
- **子Agent集群**: 这是一个由多个专业化子Agent组成的团队：
    - **`web-scout-subagent` (侦察兵)**: 专注于Web应用的信息收集，如端点发现、参数识别等，并生成侦察报告供其他Agent使用。
    - **`vuln-find-dig-and-flag-subagent` (突击手)**: 核心攻击Agent，负责漏洞的挖掘、利用和Flag获取。它的设计是一次只专注于一种漏洞类型，保证了任务的专注和深度。
    - **`flag-exploit-subagent` (收割者)**: 这是一个特殊的Agent，当其他Agent已经确认了漏洞的存在但未能成功提取Flag时被调用。它专门负责在已知漏洞的情况下，用各种技巧来获取最终的Flag。
- **Kali Server**: 所有的底层渗透工具（如`sqlmap`）都运行在一个独立的、通过FastAPI暴露接口的Docker容器中。Agent通过调用这些API来使用工具，实现了工具与Agent逻辑的解耦。

## 3. 核心亮点：声明式的Agent编排 (YAML Driven)

`SickHackShark` 最大的技术亮点在于其**配置驱动**的设计哲学。几乎所有的系统行为——包括有哪些Agent、每个Agent的职责（System Prompt）、能使用哪些工具、应用哪些中间件——都定义在 `ctf_deepagents.yaml` 文件中。

这种设计的优势是巨大的：

- **高度灵活性与可定制化**: 面对不同类型的CTF题目，分析人员只需修改YAML文件，就可以轻松地组合出不同的Agent团队。例如，对于一个纯Web的题目，可以只加载Web相关的Agent；对于一个需要代码审计的题目，可以加入一个代码审计Agent。
- **易于维护与迭代**: 当需要调整某个Agent的行为（例如，优化它的Prompt）或者增删工具时，只需修改配置文件，无需触碰和重新编译核心代码。这大大降低了维护成本，并使得版本管理和快速回滚成为可能。
- **模块化与可扩展性**: 每个Agent及其配置都是一个独立的模块，职责清晰。添加一个全新的Agent，只需要在YAML中增加一个新的配置节，并实现其对应的逻辑即可。

## 4. 强大的中间件系统

为了提升系统的稳定性和智能性，`SickHackShark` 设计了一套强大的中间件系统，这些中间件也可以在YAML中为不同的Agent灵活配置。

- **`ModelFallbackMiddleware` (模型降级)**: 当主LLM模型（如GPT-4）因API错误或超时而无法工作时，系统会自动切换到一个备用的、可能性能稍弱但更稳定的模型（如GPT-3.5），保证了任务的连续性。
- **`ImportantNotesMiddleware` (重要笔记)**: 自动从对话历史中提取和保存关键信息，形成一个简短的摘要，帮助Agent在长任务中保持对核心信息的关注。
- **`ContextEditingMiddleware` (上下文编辑)**: 这是保证Agent在长对话中不“失忆”、不“崩溃”的关键。它包含了两个核心机制：
    - **`LongChainWakeUp` (长链唤醒)**: 在一个很长的任务链中，Agent可能会忘记早期的重要发现。这个机制会定期将“重要笔记”中的信息重新注入到上下文中，以“唤醒”Agent的记忆。
    - **`ClearToolUsesEdit` (工具使用清理)**: Agent的上下文长度是有限的。这个机制会定期清理掉历史的、不那么重要的工具调用记录，为新的、更重要的信息腾出空间。

## 5. 总结与启发

`SickHackShark` 是一个将软件工程思想与AI Agent设计完美结合的杰作。它向我们展示了，一个成熟的Agent系统不应该是一堆杂乱的Prompt和硬编码的逻辑，而应该是一个**可配置、可编排、可扩展**的健壮框架。

**核心启发**：

- **配置优于编码**: 对于Agent的行为和团队组成，应尽可能使用声明式的配置文件来定义，而不是硬编码在代码里。这为系统的灵活性和可维护性带来了质的飞跃。
- **中间件是Agent的“增强插件”**: 像Web框架一样，为Agent系统设计一套中间件架构，可以优雅地解决上下文管理、模型容错、日志记录等通用问题。
- **长上下文管理是核心挑战**: 所有严肃的Agent应用都会面临上下文窗口的限制。`SickHackShark` 的长链唤醒和工具使用清理机制，为解决这个问题提供了非常实用的思路。
- **LangGraph的潜力**: 该项目也展示了LangGraph在构建非线性的、有状态的多Agent协作流程方面的巨大潜力。

`sickhack` 队伍以其深厚的工程实践，为我们构建企业级的、可维护的、灵活的AI安全Agent系统提供了一个极具参考价值的范本。
